/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analyzer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.AbstractResolverForProject;
import org.jetbrains.kotlin.analyzer.ModuleContent;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.analyzer.PackageOracle;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentProviderKt;
import org.jetbrains.kotlin.descriptors.PackageFragmentProviderOptimized;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001f\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B3\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0010H\u0016J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u00102\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u0010H\u0016J*\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00100\u001c2\u0006\u0010\u0014\u001a\u00020\u00102\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001a0\u001eH\u0016J\u0010\u0010 \u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u0010H\u0002J\n\u0010!\u001a\u00020\"H\u0096\u0080\u0004R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/analyzer/DelegatingPackageFragmentProvider;", "M", "Lorg/jetbrains/kotlin/analyzer/ModuleInfo;", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentProviderOptimized;", "resolverForProject", "Lorg/jetbrains/kotlin/analyzer/AbstractResolverForProject;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "moduleContent", "Lorg/jetbrains/kotlin/analyzer/ModuleContent;", "packageOracle", "Lorg/jetbrains/kotlin/analyzer/PackageOracle;", "<init>", "(Lorg/jetbrains/kotlin/analyzer/AbstractResolverForProject;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/analyzer/ModuleContent;Lorg/jetbrains/kotlin/analyzer/PackageOracle;)V", "syntheticFilePackages", "", "Lorg/jetbrains/kotlin/name/FqName;", "getPackageFragments", "", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentDescriptor;", "fqName", "collectPackageFragments", "", "packageFragments", "", "isEmpty", "", "getSubPackagesOf", "", "nameFilter", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/name/Name;", "certainlyDoesNotExist", "toString", "", "frontend"})
@SourceDebugExtension(value={"SMAP\nAbstractResolverForProject.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractResolverForProject.kt\norg/jetbrains/kotlin/analyzer/DelegatingPackageFragmentProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,371:1\n1586#2:372\n1661#2,3:373\n*S KotlinDebug\n*F\n+ 1 AbstractResolverForProject.kt\norg/jetbrains/kotlin/analyzer/DelegatingPackageFragmentProvider\n*L\n277#1:372\n277#1:373,3\n*E\n"})
final class DelegatingPackageFragmentProvider<M extends ModuleInfo>
implements PackageFragmentProviderOptimized {
    @NotNull
    private final AbstractResolverForProject<M> resolverForProject;
    @NotNull
    private final ModuleDescriptor module;
    @NotNull
    private final PackageOracle packageOracle;
    @NotNull
    private final Set<FqName> syntheticFilePackages;

    /*
     * WARNING - void declaration
     */
    public DelegatingPackageFragmentProvider(@NotNull AbstractResolverForProject<M> resolverForProject, @NotNull ModuleDescriptor module2, @NotNull ModuleContent<? extends M> moduleContent, @NotNull PackageOracle packageOracle) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(resolverForProject, "resolverForProject");
        Intrinsics.checkNotNullParameter(module2, "module");
        Intrinsics.checkNotNullParameter(moduleContent, "moduleContent");
        Intrinsics.checkNotNullParameter(packageOracle, "packageOracle");
        this.resolverForProject = resolverForProject;
        this.module = module2;
        this.packageOracle = packageOracle;
        Iterable iterable = moduleContent.getSyntheticFiles();
        DelegatingPackageFragmentProvider delegatingPackageFragmentProvider = this;
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KtFile ktFile = (KtFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPackageFqName());
        }
        delegatingPackageFragmentProvider.syntheticFilePackages = CollectionsKt.toSet((List)destination$iv$iv);
    }

    @Override
    @NotNull
    public List<PackageFragmentDescriptor> getPackageFragments(@NotNull FqName fqName) {
        Intrinsics.checkNotNullParameter(fqName, "fqName");
        if (this.certainlyDoesNotExist(fqName)) {
            return CollectionsKt.emptyList();
        }
        return this.resolverForProject.resolverForModuleDescriptor(this.module).getPackageFragmentProvider().getPackageFragments(fqName);
    }

    @Override
    public void collectPackageFragments(@NotNull FqName fqName, @NotNull Collection<PackageFragmentDescriptor> packageFragments) {
        Intrinsics.checkNotNullParameter(fqName, "fqName");
        Intrinsics.checkNotNullParameter(packageFragments, "packageFragments");
        if (this.certainlyDoesNotExist(fqName)) {
            return;
        }
        PackageFragmentProviderKt.collectPackageFragmentsOptimizedIfPossible(this.resolverForProject.resolverForModuleDescriptor(this.module).getPackageFragmentProvider(), fqName, packageFragments);
    }

    @Override
    public boolean isEmpty(@NotNull FqName fqName) {
        Intrinsics.checkNotNullParameter(fqName, "fqName");
        if (this.certainlyDoesNotExist(fqName)) {
            return true;
        }
        return PackageFragmentProviderKt.isEmpty(this.resolverForProject.resolverForModuleDescriptor(this.module).getPackageFragmentProvider(), fqName);
    }

    @Override
    @NotNull
    public Collection<FqName> getSubPackagesOf(@NotNull FqName fqName, @NotNull Function1<? super Name, Boolean> nameFilter) {
        Intrinsics.checkNotNullParameter(fqName, "fqName");
        Intrinsics.checkNotNullParameter(nameFilter, "nameFilter");
        if (this.certainlyDoesNotExist(fqName)) {
            return CollectionsKt.emptyList();
        }
        return this.resolverForProject.resolverForModuleDescriptor(this.module).getPackageFragmentProvider().getSubPackagesOf(fqName, nameFilter);
    }

    private final boolean certainlyDoesNotExist(FqName fqName) {
        if (this.resolverForProject.isResolverForModuleDescriptorComputed$frontend(this.module)) {
            return false;
        }
        return !this.packageOracle.packageExists(fqName) && !this.syntheticFilePackages.contains(fqName);
    }

    @NotNull
    public String toString() {
        return "DelegatingProvider for " + this.module + " in " + this.resolverForProject.getName();
    }
}

