/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.options;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.gradle.api.internal.tasks.options.AbstractOptionElement;
import org.gradle.api.internal.tasks.options.InstanceOptionDescriptor;
import org.gradle.api.internal.tasks.options.OptionDescriptor;
import org.gradle.api.internal.tasks.options.PropertySetter;
import org.gradle.api.tasks.options.Option;
import org.gradle.internal.typeconversion.TypeConversionException;

public class BooleanOptionElement
extends AbstractOptionElement {
    private static final String DISABLE_DESC_PREFIX = "Disables option --";
    private static final String OPPOSITE_DESC_PREFIX = "Opposite option of --";
    private static final String DISABLE_NAME_PREFIX = "no-";
    private final PropertySetter setter;
    private final boolean newOptionValue;

    public BooleanOptionElement(String optionName, Option option, PropertySetter setter) {
        super(optionName, option, Void.TYPE, setter.getDeclaringClass());
        this.setter = setter;
        this.newOptionValue = true;
    }

    private BooleanOptionElement(String optionName, String optionDescription, PropertySetter setter, boolean newOptionValue) {
        super(optionDescription, optionName, Void.TYPE);
        this.setter = setter;
        this.newOptionValue = newOptionValue;
    }

    public static BooleanOptionElement oppositeOf(BooleanOptionElement optionElement) {
        String optionName = optionElement.getOptionName();
        return optionElement.isDisableOption() ? new BooleanOptionElement(BooleanOptionElement.removeDisablePrefix(optionName), OPPOSITE_DESC_PREFIX + optionName + ".", optionElement.setter, false) : new BooleanOptionElement(DISABLE_NAME_PREFIX + optionName, DISABLE_DESC_PREFIX + optionName + ".", optionElement.setter, false);
    }

    public static Comparator<OptionDescriptor> groupOppositeOptions() {
        return Comparator.comparing(optionDescriptor -> {
            BooleanOptionElement optionElement;
            InstanceOptionDescriptor instanceOptionDescriptor;
            if (optionDescriptor instanceof InstanceOptionDescriptor && (instanceOptionDescriptor = (InstanceOptionDescriptor)optionDescriptor).getOptionElement() instanceof BooleanOptionElement && (optionElement = (BooleanOptionElement)instanceOptionDescriptor.getOptionElement()).isDisableOption()) {
                return BooleanOptionElement.removeDisablePrefix(optionElement.getOptionName()) + "-";
            }
            return optionDescriptor.getName();
        });
    }

    public boolean isDisableOption() {
        return this.getOptionName().startsWith(DISABLE_NAME_PREFIX);
    }

    @Override
    public Set<String> getAvailableValues() {
        return Collections.emptySet();
    }

    @Override
    public void apply(Object object, List<String> parameterValues) throws TypeConversionException {
        this.setter.setValue(object, this.newOptionValue);
    }

    private static String removeDisablePrefix(String optionName) {
        return optionName.substring(DISABLE_NAME_PREFIX.length());
    }
}

